import itertools
import yaml
import os

def create_directory(directory_path):
    if not os.path.exists(directory_path):
        os.makedirs(directory_path)
        # print(f"Directory '{directory_path}' created.")
    else:
        print(f"Directory '{directory_path}' already exists.")

model = 'resnet20'
model_dir = f'models_{model}/'
maper_dir = 'mapper/mapper.yaml'
layer_nums = [1,2,8,9,14,15,20]
in_dim = '64x64'

shell_file = f"run_resnet20_{in_dim}.sh"
with open(shell_file,'w') as file:
    file.write("#!/bin/bash")
    file.write("\n")

### config 1-2
#layer1 = 8w8a1c1pe_fpadc (1c,2c,fpadc,spadc)
#layers 2-13= 8w8a1c3pe_fpadc (1c,2c,fpadc,spadc)
#layers 14-19= 8w8a1c6pe_fpadc (1c,2c,fpadc,spadc)
#layer 20= 8w8a1c1pe_fpadc (1c,2c,fpadc,spadc)

bits = [1,2]
precisions = ['fpadc','spadc']

with open(shell_file,'a+') as file:
    for bit, precision in itertools.product(bits, precisions):
        save_dir = f'outputs/resnet20_{in_dim}_{precision}_{bit}c_baseline/'
        for layer in layer_nums:
            dir = save_dir+f'layer{layer}'
            create_directory(dir)
            if layer==1:
                arch = f'8w8a{bit}c1pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PE1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif layer==20:
                if in_dim =='32x32':
                    arch = f'8w8a{bit}c1pe_{precision}' 
                elif in_dim =='64x64':
                    arch = f'8w8a{bit}c2pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PE1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif 2 <= layer <= 13:
                arch = f'8w8a{bit}c3pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PEx.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif 14 <= layer <= 19:
                arch = f'8w8a{bit}c6pe_{precision}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PEx.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            file.write(command)
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")
            file.write(f"echo done {model}_layer{layer}_{in_dim}_{arch}.")
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")

### config 3
#layer1 = 8w8a1c1pe_fpadc (1c,2c)
#layers 2-13= 4w4a1c3pe_1smtj (1c,2c)(1smtj, 4smtj)
#layers 14-19= 4w4a1c6pe_1smtj (1c,2c)(1smtj, 4smtj)
#layer 20= 4w4a1c1pe_fpadc (1c,2c)
bits = [1,2]
samples = ['1smtj','4smtj']

with open(shell_file,'a+') as file:
    for bit, sample in itertools.product(bits, samples):
        save_dir = f'outputs/resnet20_{in_dim}_{sample}_{bit}c_config3/'
        for layer in layer_nums:
            dir = save_dir+f'layer{layer}'
            create_directory(dir)
            if (layer==1):
                arch = f'8w8a{bit}c1pe_fpadc'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PE1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            if (layer==20):
                if in_dim =='32x32':
                    arch = f'4w4a{bit}c1pe_fpadc'
                elif in_dim =='64x64':
                    arch = f'4w4a{bit}c2pe_fpadc'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PE1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif 2 <= layer <= 13:
                arch = f'4w4a{bit}c3pe_{sample}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PEx.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif 14 <= layer <= 19:
                arch = f'4w4a{bit}c6pe_{sample}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PEx.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            file.write(command)
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")
            file.write(f"echo done {model}_layer{layer}_{in_dim}_{arch}.")
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")


### config 4
#layer1 = 4w4a1c1pe_16smtj (1c,2c)
#layers 2-13= 4w4a1c3pe_1smtj (1c,2c)(1smtj, 4smtj)
#layers 14-19= 4w4a1c6pe_1smtj (1c,2c)(1smtj, 4smtj)
#layer 20= 4w4a1c1pe_fpadc (1c,2c)
bits = [1,2]
samples = ['1smtj','4smtj']

with open(shell_file,'a+') as file:
    for bit, sample in itertools.product(bits, samples):
        save_dir = f'outputs/resnet20_{in_dim}_{sample}_{bit}c_config4/'
        for layer in layer_nums:
            dir = save_dir+f'layer{layer}'
            create_directory(dir)
            if (layer==1):
                arch = f'4w4a{bit}c1pe_16smtj'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PE1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            if (layer==20):
                if in_dim =='32x32':
                    arch = f'4w4a{bit}c1pe_fpadc'
                elif in_dim =='64x64':
                    arch = f'4w4a{bit}c2pe_fpadc'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PE1.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif 2 <= layer <= 13:
                arch = f'4w4a{bit}c3pe_{sample}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PEx.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            elif 14 <= layer <= 19:
                arch = f'4w4a{bit}c6pe_{sample}'
                arch_dir = f'{model_dir}{arch}/system_PIM.yaml'
                components_dir=f'{model_dir}{arch}/components/*.yaml'
                constraints_dir = 'constraints/constraints_PEx.yaml'
                problem_dir = f'layer_shapes/{model}_{in_dim}/layer{layer}.yaml'
                output_dir = save_dir+f'layer{layer}'
                command = f'timeloop-mapper {arch_dir} {components_dir} {maper_dir} {constraints_dir} {problem_dir} -o {output_dir}'
            file.write(command)
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")
            file.write(f"echo done {model}_layer{layer}_{in_dim}_{arch}.")
            file.write("\n")
            file.write("echo " + "#"*80)
            file.write("\n")